#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <sys/stat.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <errno.h>
#include <string.h>
#include <linux/stat.h>

#include <gvd-common.h>
#include <gvd-control.h>
#include <gvd-asyncwatch.h>
#include <gvd-ipmonitor.h>
#include <gvd-debug.h>
#include <gvd-config.h>

#include <gvd.h>


      

pthread_mutex_t logbuf_mutex;
pthread_mutex_t link_table_mutex;
pthread_mutex_t event_list_mutex;
pthread_mutex_t event_condition_mutex;
pthread_cond_t  event_condition_cond=PTHREAD_COND_INITIALIZER;
int     gvd_normal_exit=0;


void gvd_unexpected_thread_exit(void* arg){
    const char* who=(const char*)arg;
    if (!gvd_normal_exit) {
        gvd_debug(DBG_MOD_GENERAL,DBG_PANIC,"unexpected termination of thread %s\n",who);
        gvd_exit(NULL,NULL);
    }
}
int gvd_mutex_init(pthread_mutex_t* mutex){
    pthread_mutexattr_t mutexattr;
    pthread_mutexattr_init(&mutexattr);
    pthread_mutexattr_settype(&mutexattr,PTHREAD_MUTEX_RECURSIVE_NP);
    pthread_mutex_init(mutex,&mutexattr);
    pthread_mutexattr_destroy(&mutexattr);
    return 0;
}


void gvd_atexit(void){
    time_t now=time(NULL);
    gvd_debug(DBG_MOD_GENERAL,DBG_DUMP,"gvd terminated at %s",ctime(&now));
    gvd_print_log_buf(1);
}


static const char *opt_debug_level=NULL;
static const char *opt_log_file=NULL;
static const char *opt_log_max_size=NULL;
int gvd_set_opt(void){
    
    if(opt_debug_level)
        debug_level = atoi(opt_debug_level);
    if(opt_log_file)
        log_file = opt_log_file;
    if(opt_log_max_size)
        log_max_size = atoi(opt_log_max_size);
    return 1;

}
int main(int argc, char **argv){


    int index;
    int c;
    int i;
    time_t now=time(NULL);
    pthread_t  th_ipmonitor, th_ipmonitor_handler;
    pthread_t  th_dev_watch[GVD_MAX_IB_DEVICES];
    int        n_devices=GVD_MAX_IB_DEVICES;
    opterr = 0;
    key_t key;
    int msqid;
    int is_daemon=1;
    
    atexit(gvd_atexit);
    gvd_debug(DBG_MOD_GENERAL,DBG_DUMP,"gvd started at %s",ctime(&now));
    key = ftok(GVD_MSGQ_PATH, GVD_MSGQ_FLAG);
    if ((msqid = msgget(key, 0666)) < 0){
        if(errno != ENOENT){
            gvd_debug(DBG_MOD_UTIL,DBG_PANIC,"fail to get msg queue id for %s/%c\n",GVD_MSGQ_PATH,GVD_MSGQ_FLAG);
            return 0;
        }
    }else{
        if(msgctl(msqid, IPC_RMID, NULL)<0){
            gvd_debug(DBG_MOD_UTIL,DBG_PANIC,"fail to delete message queue %d\n",msqid);
            return 0;
        }
    }
    while ((c = getopt (argc, argv, "d:l:c:L:D")) != -1)
        switch (c) {
        case 'd':
            opt_debug_level=optarg;
            break;
        case 'l':
            opt_log_file = optarg;
            break;
        case 'c':
            conf_file = optarg;
            break;
        case 'L':
            opt_log_max_size = optarg;
            break;
        case 'D':
            is_daemon=0;
            break;
        case '?':
            printf("unknow option -%c\n",optopt);
            return 1;
        default:
            return 1;
        }



    for (index = optind; index < argc; index++) {
        printf ("non-option argument %s\n", argv[index]);
    }
    
    if (is_daemon &&(daemon(0,0)<0)) {
        perror("daemon:");
        exit(1);
    }

    gvd_read_conf(conf_file,0);
    gvd_set_opt();
    
    gvd_mutex_init(&logbuf_mutex);
    gvd_mutex_init(&link_table_mutex);
    gvd_mutex_init(&event_list_mutex);
    gvd_mutex_init(&event_condition_mutex);

    pthread_create( &th_ipmonitor, NULL, gvd_ipmonitor, (void*) NULL);
    pthread_create( &th_ipmonitor_handler, NULL, gvd_ipmonitor_handler, (void*) NULL);
    if(!gvd_asyncwatch_start(th_dev_watch,&n_devices)){
        gvd_debug(DBG_MOD_ASYNCW,DBG_PANIC,"failed to start device watch for async events%s\n","");
        return 1;
    }
    
    gvd_control_listen(NULL);

    pthread_cancel(th_ipmonitor);    
    pthread_cancel(th_ipmonitor_handler);
    for(i=0;i<n_devices;i++)
        pthread_cancel(th_dev_watch[i]);

    pthread_join( th_ipmonitor, NULL); 
    pthread_join( th_ipmonitor_handler, NULL); 
    for(i=0;i<n_devices;i++)
        pthread_join(th_dev_watch[i],NULL);
    return 0;
}
